#!/usr/bin/env python3
from collections import Counter

words = set(open('slowa.txt').read().splitlines())
blacklist = set(open('blacklist.txt').read().splitlines())
n = len(words)
found = 0
stats = Counter()
results = []

for idx, d in enumerate(words, 1):
    for i in range(1, len(d)):
        for j in range(i + 1, len(d)):
            a, b, c = d[:i], d[i:j], d[j:]
            if a in words and b in words and c in words and a not in blacklist and b not in blacklist and c not in blacklist:
                results.append((a, b, c, d))
                found += 1
                stats[a] += 1
                stats[b] += 1
                stats[c] += 1
        if idx % 10000 == 0:
            print(f"\r{idx}/{n}  znaleziono: {found}", end='', flush=True)

with open('wyniki_posortowane_po_a.txt', 'w') as out:
    for a, b, c, d in sorted(results, key=lambda abc: abc[0]):
        out.write(f"{a} + {b} + {c} = {d}\n")

with open('wyniki_posortowane_po_b.txt', 'w') as out:
    for a, b, c, d in sorted(results, key=lambda abc: abc[1]):
        out.write(f"{a} + {b} + {c} = {d}\n")

with open('wyniki_posortowane_po_c.txt', 'w') as out:
    for a, b, c, d in sorted(results, key=lambda abc: abc[2]):
        out.write(f"{a} + {b} + {c} = {d}\n")

print(f"\r{n}/{n} znaleziono: {found}")
print("Zapisano do wyniki_posortowane_po_{a,b,c}.txt")

with open('statystyki.txt', 'w') as f:
    for word, count in stats.most_common():
        f.write(f"{word}\t{count}\n")

print(f"Statystyki ({len(stats)} słów) zapisano do statystyki.txt")

