unit Unit8;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

type
  TForm8 = class(TForm)
    ListBox1: TListBox;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    MainMenu1: TMainMenu;
    Plik1: TMenuItem;
    Otwrz1: TMenuItem;
    Zapisz1: TMenuItem;
    Edycja1: TMenuItem;
    Usustacje1: TMenuItem;
    Edytujstacje1: TMenuItem;
    Dodajstacje1: TMenuItem;
    pom: TMemo;
    zmienazwe1: TMenuItem;
    zmienumerselcall1: TMenuItem;
    usuczestotliwo1: TMenuItem;
    dodajczstotliwo1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1KeyPress(Sender: TObject; var Key: Char);
    procedure Button1Click(Sender: TObject);
    procedure Otwrz1Click(Sender: TObject);
    procedure Zapisz1Click(Sender: TObject);
    procedure Usustacje1Click(Sender: TObject);
    procedure Dodajstacje1Click(Sender: TObject);
    procedure zmienazwe1Click(Sender: TObject);
    procedure zmienumerselcall1Click(Sender: TObject);
    procedure usuczestotliwo1Click(Sender: TObject);
    procedure dodajczstotliwo1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    pos1, pos2: integer;
    procedure refresh_frequencies;
  end;

var
  Form8: TForm8;

implementation

uses Unit1, Unit3;

{$R *.DFM}
procedure TForm8.refresh_frequencies;
var
 i: integer;
 Rx_l, Tx_l, selcall_l,a:string;
begin
 //znajdujemy wybrana stacje w ksiazce
 for i:=0 to Form1.KsiazkaAdresowa.Lines.count-1 do begin
  if (Form1.KsiazkaAdresowa.Lines[i]='#'+ListBox1.Items[ListBox1.ItemIndex]) then begin
   pos1:=i;
   break;
  end;
 end;
 //znajdujemy koniec sekcji tej stacji w ksiazce
 for i:=pos1+1 to Form1.KsiazkaAdresowa.Lines.count-1 do begin
  if (Form1.KsiazkaAdresowa.Lines[i][1]='#') then begin
   pos2:=i;
   break;
  end;
 end;
 selcall_l:=Form1.KsiazkaAdresowa.Lines[pos1+1];
 i:=pos1+2;
 ComboBox1.Items.Clear;
 ComboBox1.Text:='';
 while (i<pos2-1) do begin
  rx_l:=Form1.KsiazkaAdresowa.Lines[i];
  if length(rx_l)>7 then rx_l:='1000   ' else begin
   while (length(rx_l)<7) do begin
    rx_l:=rx_l+' ';
   end;
  end;
  tx_l:=Form1.KsiazkaAdresowa.Lines[i+1];
  if length(tx_l)>7 then tx_l:='1000   ' else begin
   while (length(tx_l)<7) do begin
    tx_l:=tx_l+' ';
   end;
  end;
  a:='Rx='+rx_l+'    '+'Tx='+tx_l+'  ';
  ComboBox1.Items.Add(a);
  inc(i,2);
 end;
 ComboBox1.ItemIndex:=1;
 Edit1.Text:=selcall_l;
end;

procedure TForm8.FormActivate(Sender: TObject);
 var
  i: integer;
begin
 //wypisujemy stacje
 ListBox1.Items.Clear;
 for i:=0 to Form1.KsiazkaAdresowa.Lines.count-1 do begin
  if (Form1.KsiazkaAdresowa.Lines[i][1]='#') then ListBox1.Items.Add(copy(Form1.KsiazkaAdresowa.Lines[i],2,length(Form1.KsiazkaAdresowa.Lines[i])-1));
 end;
 Listbox1.ItemIndex:=1;
 refresh_frequencies;
end;

procedure TForm8.ListBox1Click(Sender: TObject);
begin
 refresh_frequencies;
end;

procedure TForm8.ListBox1DblClick(Sender: TObject);
begin
 refresh_frequencies;
end;

procedure TForm8.ListBox1KeyPress(Sender: TObject; var Key: Char);
begin
 refresh_frequencies;
end;

procedure TForm8.Button1Click(Sender: TObject);
begin
 Form1.Selcall:=StrToInt(Edit1.Text);
 Form1.Rx:=StrToFloat(copy(ComboBox1.Text,4,7));
 Form1.Tx:=StrToFloat(copy(ComboBox1.Text,18,7));
 form3.StatusBar1.Panels[1].text:='Rx: '+FloatToStr(Form1.Rx);
 form3.StatusBar1.Panels[2].text:='Tx: '+FloatToStr(Form1.Tx);
 form3.StatusBar1.Panels[3].text:='Selcall number: '+IntToStr(Form1.Selcall);
 Form8.hide;
 
end;

procedure TForm8.Otwrz1Click(Sender: TObject);
begin
 if Form1.OpenDialog1.Execute then begin
  Form1.KsiazkaAdresowa.Lines.LoadFromFile(Form1.OpenDialog1.FileName);
 end;
 FormActivate(self);
end;

procedure TForm8.Zapisz1Click(Sender: TObject);
begin
 if Form1.SaveDialog1.Execute then begin
  Form1.KsiazkaAdresowa.Lines.SaveToFile(Form1.SaveDialog1.FileName);
 end;
end;

procedure TForm8.Usustacje1Click(Sender: TObject);
var
 i: integer;
begin
 pom.text:='';
 for i:=0 to pos1-1 do begin
  pom.lines.add(Form1.KsiazkaAdresowa.Lines[i]);
 end;
 if pos2<Form1.KsiazkaAdresowa.Lines.Count then begin
  for i:=pos2 to Form1.KsiazkaAdresowa.Lines.Count-1 do begin
   pom.lines.add(Form1.KsiazkaAdresowa.lines[i]);
  end;
 end;
 Form1.KsiazkaAdresowa.text:=pom.Text;
 FormActivate(self);
end;

procedure TForm8.Dodajstacje1Click(Sender: TObject);
var
 i, pos: integer;
begin
 pos:=Form1.KsiazkaAdresowa.Lines.count-1;
 for i:=0 to Form1.KsiazkaAdresowa.Lines.count-1 do begin
  if Form1.KsiazkaAdresowa.Lines[i]='#' then pos:=i;
 end;
 Form1.KsiazkaAdresowa.Lines[pos]:='#nowa stacja';
 Form1.KsiazkaAdresowa.Lines.Add('8888');
 Form1.KsiazkaAdresowa.Lines.Add('#');
 FormActivate(self);
end;

procedure TForm8.zmienazwe1Click(Sender: TObject);
begin
 Form1.KsiazkaAdresowa.lines[pos1]:='#'+InputBox('Telex','Podaj now nazwe stacji','');
 FormActivate(self);
end;

procedure TForm8.zmienumerselcall1Click(Sender: TObject);
begin
 Form1.KsiazkaAdresowa.lines[pos1+1]:=InputBox('Telex','Podaj nowy numer selcall stacji','');
 FormActivate(self);
end;

procedure TForm8.usuczestotliwo1Click(Sender: TObject);
var
 i: integer;
begin
 pom.text:='';
 for i:=0 to pos1+(ComboBox1.ItemIndex*2)+1 do begin
  pom.lines.add(Form1.KsiazkaAdresowa.Lines[i]);
 end;
 if pos1+(ComboBox1.ItemIndex*2)+3<Form1.KsiazkaAdresowa.Lines.count-1 then begin
  for i:=pos1+(ComboBox1.ItemIndex*2)+4 to Form1.KsiazkaAdresowa.Lines.count-1 do begin
   pom.lines.add(Form1.KsiazkaAdresowa.Lines[i]);
  end;
 end;
 Form1.KsiazkaAdresowa.Text:=pom.text;
 FormActivate(self);
end;

procedure TForm8.dodajczstotliwo1Click(Sender: TObject);
var
 i: integer;
begin
 pom.text:='';
 for i:=0 to pos1+1 do begin
  pom.lines.add(Form1.KsiazkaAdresowa.Lines[i]);
 end;
 pom.lines.add(InputBox('Telex','Rx = ?',''));
 pom.lines.add(InputBox('Telex','Tx = ?',''));
 if pos1+1<Form1.KsiazkaAdresowa.Lines.count-1 then begin
  for i:=pos1+2 to Form1.KsiazkaAdresowa.Lines.count-1 do begin
   pom.lines.add(Form1.KsiazkaAdresowa.Lines[i]);
  end;
 end;
 Form1.KsiazkaAdresowa.Text:=pom.text;
 FormActivate(self);
end;

end.
