#!/usr/bin/env python3

# generated with ai

import fontforge
import sys

uppers = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 
          'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 
          'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
          'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 
          'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 
          'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
          '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
          ' ', '.', ',', '!', '?', ';', "'"]

def copy_glyph_to_all_targets(source_glyph, target_font, target_chars):
    """Kopiuje geometrię source_glyph do wszystkich znaków w target_chars w target_font"""
    
    # Ustaw typ fontu docelowego zgodnie ze źródłem
    target_font.layers['Fore'].is_quadratic = source_glyph.layers[1].is_quadratic
    
    for target_char in target_chars:
        target_code = ord(target_char)
        new_glyph = target_font.createChar(target_code)
        new_glyph.clear()
        
        pen = new_glyph.glyphPen()
        source_glyph.draw(pen)
        pen = None
        
        new_glyph.width = source_glyph.width

source_font_path = sys.argv[1] if len(sys.argv) > 1 else "/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf"
source = fontforge.open(source_font_path)

for template_char in uppers:
    template_code = ord(template_char)
    output_name = f"uniform_{template_code}.ttf"
    font_name = f"Uniform{template_code}"
    
    if template_code not in source:
        print(f"OSTRZEŻENIE: Znak '{template_char}' (U+{template_code:04X}) nie istnieje w foncie źródłowym")
        continue
    
    template_glyph = source[template_code]
    
    new_font = fontforge.font()
    new_font.fontname = font_name
    new_font.familyname = font_name
    new_font.fullname = font_name
    new_font.em = source.em
    new_font.ascent = source.ascent
    new_font.descent = source.descent
    
    copy_glyph_to_all_targets(template_glyph, new_font, uppers)
    
    new_font.generate(output_name)
    new_font.close()

source.close()

