#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# generated with ai

import sys

if len(sys.argv) != 3:
    print("Usage: python3 create_document.py 'logical' 'visual'", file=sys.stderr)
    sys.exit(1)

logical = sys.argv[1]
visual = sys.argv[2]

max_len = max(len(logical), len(visual))
logical = logical.ljust(max_len)
visual = visual.ljust(max_len)

def code_to_letters(code):
    """Converts character code to string composed only of a-z letters"""
    result = ""
    while code > 0:
        result = chr(97 + (code % 26)) + result
        code //= 26
    return result if result else "a"

preamble = r"""\documentclass{article}
\usepackage{fontspec}
\usepackage[margin=2cm]{geometry}
\newfontface\basefont{DejaVuSans.ttf}[Path=/usr/share/fonts/truetype/dejavu/]
"""

font_defs = {}
body_parts = []
i = 0

while i < max_len:
    log_char = logical[i]
    vis_char = visual[i]
    
    # Space warning
    if log_char == ' ' and vis_char != ' ':
        start = max(0, i - 7)
        end = min(max_len, i + 8)
        log_context = logical[start:end]
        vis_context = visual[start:end]
        print(f"Warning: space in logical text will be visible at position {i}", file=sys.stderr)
        print(f"  Logical context: '{log_context}'", file=sys.stderr)
        print(f"  Visual context:  '{vis_context}'", file=sys.stderr)
    
    # Same characters - use base font
    if log_char == vis_char:
        j = i
        while j < max_len and logical[j] == visual[j]:
            j += 1
        body_parts.append(f"{{\\basefont{{{logical[i:j]}}}}}")
        i = j
    else:
        code = ord(vis_char)
        font_name = f"font{code_to_letters(code)}"
        
        if code not in font_defs:
            font_defs[code] = font_name
        
        body_parts.append(f"{{\\{font_name}{{{log_char}}}}}")
        i += 1

font_declarations = "\n".join(
    f"\\newfontface\\{name}{{uniform_{code}.ttf}}"
    for code, name in sorted(font_defs.items())
)

document = f"""{preamble}{font_declarations}
\\begin{{document}}
{"".join(body_parts)}
\\end{{document}}
"""

with open("document.tex", "w", encoding="utf-8") as f:
    f.write(document)

print("document.tex")

